// LightingView.cpp : implementation of the CLightingView class
//

#include "stdafx.h"
#include "Lighting.h"

#include "LightingDoc.h"
#include "LightingView.h"

#include <math.h> // for fabs()

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CLightingView

IMPLEMENT_DYNCREATE(CLightingView, COpenGLView)

BEGIN_MESSAGE_MAP(CLightingView, COpenGLView)
	//{{AFX_MSG_MAP(CLightingView)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CLightingView construction/destruction

CLightingView::CLightingView()
{
	// TODO: add construction code here
	m_Z = -6.0;
	m_rotY = 20.0;
	m_rotX = -35.0f;
//	m_rotaccelX = 33.;
//	m_rotaccelY = 66.;
//	m_rotaccelZ = 20.;
//	m_accelZ = -5.0;

	ToggleAnimationFlag();

	SelectStockScene(eStockSceneNone);
	
}

// Control the animation
BOOL CLightingView::PreRenderScene( void )
{
	// toggle the velocity in the Z direction
	if ( m_Z <= -19.0  )
		{
		m_accelZ = fabs(m_accelZ);
		}
	else if (  m_Z >= -3.0 )
		{
		m_accelZ = -fabs(m_accelZ);
		}

	return ViewpointOriginRotation();
}


BOOL CLightingView::RenderScene( void )
{

	GLfloat materialSpecular[4] = { 0.33f, 0.33f, 0.33f, 1.0f };
	
	GLfloat materialShininess[1] = { 35.0f };

	GLfloat materialAmbDiff[4]={ 1.0f, 1.0f, 1.0f, 1.0f };

    GLfloat local_ambient[] = { 0.0f, 0.0f, 0.0f, 1.0f };
    
	::glEnable(GL_DEPTH_TEST);
    ::glDepthFunc(GL_LESS);

    ::glLightModelfv(GL_LIGHT_MODEL_AMBIENT, local_ambient);
    ::glLightModeli(GL_LIGHT_MODEL_LOCAL_VIEWER, GL_TRUE );


    GLfloat ambient0[] =  { 0.0f, 0.0f, 0.0f, 1.0f };
    GLfloat diffuse0[] =  { 0.8f, 0.8f, 0.8f, 1.0f };
    GLfloat specular0[] = { 0.0f, 1.0f, 0.0f, 1.0f };
    GLfloat position0[] = {-1.0f, -1.0f, -1.0f, 0.0f };

    GLfloat ambient1[] =  { 0.0f, 0.0f, 0.0f, 1.0f };
    GLfloat diffuse1[] =  { 0.8f, 0.8f, 0.8f, 1.0f };
    GLfloat specular1[] = { 0.8f, 0.8f, 0.8f, 1.0f };
    GLfloat position1[] = { 0.0f, -1.0f, -1.0f, 0.0f };

    GLfloat ambient2[] =  { 0.0f, 0.0f, 0.0f, 1.0f };
    GLfloat diffuse2[] =  { 0.0f, 1.0f, 0.0f, 1.0f };
    GLfloat specular2[] = { 0.8f, 0.8f, 0.8f, 1.0f };
    GLfloat position2[] = { 1.0f, -1.0f, -1.0f, 0.0f };
   

	::glDisable( GL_LIGHTING );

	::glPushMatrix();
	::glColor3fv( diffuse0 );
	::glTranslatef( position0[0], position0[1], position0[2] );
///////  	::auxWireSphere(.15f);
   	::auxSolidSphere(.05f);
	::glPopMatrix();

	::glPushMatrix();
	::glColor3fv( diffuse1 );
	::glTranslatef( position1[0], position1[1], position1[2] );
////  	::auxWireSphere(.15f);
   	::auxSolidSphere(.05f);
	::glPopMatrix();

	::glPushMatrix();
	::glColor3fv( diffuse2 );
	::glTranslatef( position2[0], position2[1], position2[2] );
/////	::auxWireSphere(.15f);
   	::auxSolidSphere(.05f);
	::glPopMatrix();

	::glEnable( GL_LIGHTING );

    ::glEnable(GL_LIGHT0);  
    ::glLightfv(GL_LIGHT0, GL_AMBIENT, ambient0);
    ::glLightfv(GL_LIGHT0, GL_POSITION, position0);
    ::glLightfv(GL_LIGHT0, GL_DIFFUSE, diffuse0);
    ::glLightfv(GL_LIGHT0, GL_SPECULAR, specular0);

    ::glEnable(GL_LIGHT1);
    ::glLightfv(GL_LIGHT1, GL_AMBIENT, ambient1);
    ::glLightfv(GL_LIGHT1, GL_POSITION, position1);
    ::glLightfv(GL_LIGHT1, GL_DIFFUSE, diffuse1);
    ::glLightfv(GL_LIGHT1, GL_SPECULAR, specular1);
	
    ::glEnable(GL_LIGHT2);  
    ::glLightfv(GL_LIGHT2, GL_AMBIENT, ambient2);
    ::glLightfv(GL_LIGHT2, GL_POSITION, position2);
    ::glLightfv(GL_LIGHT2, GL_DIFFUSE, diffuse2);
    ::glLightfv(GL_LIGHT2, GL_SPECULAR, specular2);

	::glMaterialfv( GL_FRONT, GL_SPECULAR, materialSpecular );
	::glMaterialfv( GL_FRONT, GL_SHININESS, materialShininess );
	::glMaterialfv( GL_FRONT, GL_AMBIENT_AND_DIFFUSE, materialAmbDiff );
	
	::glDisable(GL_LIGHT0);  
	::glDisable(GL_LIGHT1);  
	::glDisable(GL_LIGHT2);  


	::glPushMatrix();

	::glEnable(GL_LIGHT1);  
    ::auxSolidSphere(0.5f);

    ::glEnable(GL_LIGHT0);  
    ::glDisable(GL_LIGHT1);  
	::glTranslatef( -1.0f, 0.0f, 0.0f );
	::auxSolidSphere(0.5f);

	::glTranslatef( +2.0f, 0.0f, 0.0f );
	::glEnable(GL_LIGHT2);  
	::glDisable(GL_LIGHT0);  
	::auxSolidSphere(0.5f);
	::glPopMatrix();

	return TRUE;
}

CLightingView::~CLightingView()
{
}


/////////////////////////////////////////////////////////////////////////////
// CLightingView message handlers
